/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util;

import java.util.concurrent.ConcurrentHashMap;
import net.ftb.log.Logger;

public class Benchmark {
    private static Long baseTime;
    private static ConcurrentHashMap<String, Long> startTimes;

    public static void start(String name) {
        startTimes.put(name, System.currentTimeMillis());
    }

    public static void reset(String name) {
        if (startTimes.containsKey(name)) {
            startTimes.put(name, System.currentTimeMillis());
        } else {
            Logger.logError("Wrong key", new Exception(""));
        }
    }

    private static Long bench(String name) {
        return System.currentTimeMillis() - startTimes.get(name);
    }

    public static void logBench(String taskName) {
        if (startTimes.containsKey(taskName)) {
            Logger.logDebug(taskName + " took " + Benchmark.bench(taskName) + " ms.");
        } else {
            Logger.logError("Wrong key", new Exception(""));
        }
    }

    public static void logBenchAs(String taskName, String namedAs) {
        if (startTimes.containsKey(taskName)) {
            Logger.logDebug(namedAs + " took " + Benchmark.bench(taskName) + " ms.");
        } else {
            Logger.logError("Wrong key", new Exception(""));
        }
    }

    public static void logBenchReset(String taskName) {
        if (startTimes.containsKey(taskName)) {
            Benchmark.logBench(taskName);
            Benchmark.reset(taskName);
        } else {
            Logger.logError("Wrong key", new Exception(""));
        }
    }

    public static void logBenchAsReset(String taskName, String namedAs) {
        if (startTimes.containsKey(taskName)) {
            Benchmark.logBenchAs(taskName, namedAs);
            Benchmark.reset(taskName);
        } else {
            Logger.logError("Wrong key", new Exception(""));
        }
    }

    static {
        startTimes = new ConcurrentHashMap();
    }
}

